<!DOCTYPE html>
<html lang="en">
<head>
    <meta name="google-adsense-account" content="ca-pub-2987349950092151">
    <script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-2987349950092151"
            crossorigin="anonymous"></script>
    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-2T14VYZV0D"></script>
    <script>
        window.dataLayer = window.dataLayer || [];

        function gtag() {
            dataLayer.push(arguments);
        }

        gtag('js', new Date());

        gtag('config', 'G-2T14VYZV0D');
    </script>

    <link rel="icon" href="/favicon.png" type="image/png">
    <meta charset="UTF-8">

    <title>Topiqs: Insights on Crypto, Trading & Technology</title>
    <meta name="description" content="Explore expert articles on crypto,
    trading strategies, cutting-edge technology, business insights, and IT trends.
    Stay informed with Topiqs' in-depth analysis and popular reads.">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="/css/index.css">
</head>
<body>

<!-- Google Tag Manager (noscript) -->
<noscript>
    <iframe src="https://www.googletagmanager.com/ns.html?id=GTM-WBMFZ324"
            height="0" width="0" style="display:none;visibility:hidden"></iframe>
</noscript>
<!-- End Google Tag Manager (noscript) -->

<div class="container">
    <div class="sidebar">

            <img src="/images/main.jpeg" alt="main icon" width="230" height="230">

        <h2>Topiqs</h2>
        <ul>
            <#list chapters as chapter>
                <a href="/articles/chapter/${chapter.chapter}" class="chapter-link">
                    <img src="/images/${chapter.chapter}.jpeg" alt="${chapter.chapter}" width="30" height="30">
                    <span class="chapter-label">${chapter.chapterAndCount}</span>
                </a>
            </#list>
        </ul>
    </div>

    <div class="content">
        <h1 >Topiqs: Your Source for Crypto, Trading & Tech Articles</h1>
        <h2 style="margin-top: 50px;">Articles by Topiq:</h2>
        <ul style="list-style: none; padding: 0;">
            <#list randomArticles as article>
                <li>
                    <!-- Article Preview Card -->
                    <article class="article-preview">
                        <a href="/articles/${article.id}" class="preview-link">
                            <img src="/images/${article.chapter}.jpeg"
                                 alt="${article.chapter}"
                                 width="120" height="120">
                            <div class="preview-text">
                                <h2 class="preview-title">${article.title}</h2>
                                <p class="preview-excerpt">
                                    ${article.firstSentence}
                                </p>
                            </div>
                        </a>
                    </article>
                    </a>
                </li>
            </#list>
        </ul>

        <h2 style="margin-top: 50px;">Most Popular Articles</h2>
        <ul style="list-style: none; padding: 0;">
            <#list popularArticles as article>
                <li>
                    <!-- Article Preview Card -->
                    <article class="article-preview">
                        <a href="/articles/${article.id}" class="preview-link">
                            <img src="/images/${article.chapter}.jpeg"
                                 alt="${article.chapter}"
                                 width="120" height="120">
                            <div class="preview-text">
                                <h2 class="preview-title">${article.title}</h2>
                                <p class="preview-excerpt">
                                    ${article.firstSentence}
                                </p>
                            </div>
                        </a>
                    </article>
                    </a>
                </li>
            </#list>
        </ul>

        <footer>
            &copy; ${.now?string("yyyy")} Helpful articles :)
        </footer>
    </div>

</div>

</body>
</html>
