<!DOCTYPE html>
<html lang="en">
<head>
    <meta name="google-adsense-account" content="ca-pub-2987349950092151">
    <script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-2987349950092151"
            crossorigin="anonymous"></script>
    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-2T14VYZV0D"></script>
    <script>
        window.dataLayer = window.dataLayer || [];

        function gtag() {
            dataLayer.push(arguments);
        }

        gtag('js', new Date());

        gtag('config', 'G-2T14VYZV0D');
    </script>

    <link rel="icon" href="/favicon.png" type="image/png">
    <meta charset="UTF-8">
    <title>${article.title!"Untitled Article"}</title>
    <meta name="description" content="${article.firstSentence!''}
    Discover in-depth insights into ${article.title} on Topiqs. Learn more about it.">
    <link rel="canonical"
          href="https://topiqs.net/articles/${article.id}"/>

    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Article",
  "headline": "${article.title!""}",
  "image": [
    "https://topiqs.net/images/${article.chapter}.jpeg"
  ],
  "datePublished": "${article.lastModified!""}",
  "dateModified": "${article.lastModified!""}",
  "author": {
    "@type": "Person",
    "name": "Vic"
  },
  "publisher": {
    "@type": "Organization",
    "name": "Topiqs",
    "logo": {
      "@type": "ImageObject",
      "url": "https://topiqs.net/favicon.png"
    }
  },
  "description": "${article.firstSentence!""}"
}


    </script>

    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="/css/article.css">

</head>
<body>

<!-- Google Tag Manager (noscript) -->
<noscript>
    <iframe src="https://www.googletagmanager.com/ns.html?id=GTM-WBMFZ324"
            height="0" width="0" style="display:none;visibility:hidden"></iframe>
</noscript>
<!-- End Google Tag Manager (noscript) -->

<div class="container">
    <h1>${article.title!"Untitled Article"}</h1>

    <div class="img-container">
        <img
                class="full-height-img"
                src="/images/headers/${article.chapter}_${imageNumber}.jpeg"
                alt="AI header">
    </div>

    <div class="article-text">
        <#if article.text??>
            ${article.text}
        <#else>
            <p><em>No content provided yet.</em></p>
        </#if>
    </div>

    <div class="share-links-container">

        <a href="https://www.facebook.com/sharer/sharer.php?u=https%3A%2F%2Ftopiqs.net%2Farticles%2F${article.id}&t=${article.title}"
           target="_blank"
           title="Share on Facebook">
            <img src="/images/share_to_fb.jpeg" alt="Share on Facebook" width="60" height="60">
        </a>

        <a href="https://twitter.com/intent/tweet?url=https%3A%2F%2Ftopiqs.net%2Farticles%2F${article.id}&text=${article.title}"
           target="_blank"
           rel="noopener"
           title="Share on X">
            <img src="/images/share_to_x.jpeg" alt="Share on X" width="60" height="60">
        </a>

        <a href="https://t.me/share/url?url=https%3A%2F%2Ftopiqs.net%2Farticles%2F${article.id}&text=${article.title}"
           target="_blank"
           rel="noopener noreferrer"
           title="Share on Telegram">
            <img src="/images/share_to_telegram.jpeg" alt="Share on Telegram" width="60" height="60">
        </a>

        <a href="https://www.reddit.com/submit?url=https%3A%2F%2Ftopiqs.net%2Farticles%2F${article.id}&text=${article.title}"
           target="_blank"
           rel="noopener noreferrer"
           title="Share on Reddit">
            <img src="/images/share_to_reddit.jpeg" alt="Share on Reddit" width="60" height="60">
        </a>

        <a href="https://www.linkedin.com/shareArticle?url=https%3A%2F%2Ftopiqs.net%2Farticles%2F${article.id}&text=${article.title}"
           target="_blank"
           rel="noopener noreferrer"
           title="Share on Linkedin">
            <img src="/images/share_to_linkedin.jpeg" alt="Share on Linkedin" width="60" height="60">
        </a>

        <a href="https://api.whatsapp.com/send?text=${article.title}%20https%3A%2F%2Ftopiqs.net%2Farticles%2F${article.id}"
           target="_blank"
           rel="noopener noreferrer"
           title="Share on WhatsApp">
            <img src="/images/share_to_whatsapp.jpeg" alt="Share on WhatsApp" width="60" height="60">
        </a>

    </div>


    <p>More to read: </p>
    <ul>
        <#list nextArticles as article>
            <p><a href="/articles/${article.id}" style="color: #0057e7; text-decoration: none;">${article.title}</a></p>
        </#list>
    </ul>

</div>

<div class="comment-section-wrapper">
    <h2 style="margin-top: 0;">Add a Comment</h2> <form method="POST" action="/comment" class="comment-form">
        <label for="author">Name yourself:</label>
        <input type="text" id="author" name="author" required>

        <label for="comment">Comment:</label>
        <textarea id="comment" name="comment" required rows="5"></textarea>

        <button type="submit">Send</button>
    </form>
</div>

<#if article.comments?has_content>
    <div class="recent-comments-section">
        <h2 style="margin-top: 0;">Recent comments</h2> <ul style="list-style: none; padding-left: 0;"> <#list article.comments as comment>
                <li>
                    <p><strong>${comment.author!"Anonymous"}</strong>:</p>
                    <p>${comment.comment}</p>
                </li>
            </#list>
        </ul>
    </div>
</#if>

<a href="/" class="home-button"> <<< Home</a>

<footer>
    &copy; ${.now?string("yyyy")} Helpful articles :)
</footer>
</body>
</html>
