/*
 * Decompiled with CFR 0.152.
 */
package com.articles.core;

import com.articles.repo.domain.Chapter;
import com.articles.service.TopicService;
import java.util.Random;
import org.springframework.stereotype.Component;

@Component
public class PromptComposer {
    private final TopicService topicService;
    private String intro1 = "Imagine you're a professional ";
    private String intro2 = "and gifted articles writer.";
    private String part1 = "I need you to write an article about ";
    private String part2 = "Article should be analytical,\nbased only on real information which you can find in internet and analyse,\nwell structured,\nwritten in English\nand should contain title and about 2000 symbols.\nAlso it should have HTML markup as text and be unique.\n";

    public String composeRandom() {
        return "";
    }

    public String[] composeByTopic(Chapter topic) {
        String profession = this.getProfessionByTopic(topic);
        String articleTopic = this.getArticleTopic(topic);
        if (profession.length() < 1 || articleTopic.length() < 1) {
            return new String[0];
        }
        String[] response = new String[]{this.intro1 + profession + this.intro2, this.part1 + articleTopic + this.part2};
        return response;
    }

    private String getArticleTopic(Chapter topic) {
        String topicsAsString = this.topicService.getById(topic).getTopics();
        if (topicsAsString.length() > 1) {
            return "";
        }
        String[] topicsAsArray = topicsAsString.split(", ");
        Random random = new Random();
        int randomTopicPlace = random.nextInt(topicsAsArray.length);
        return topicsAsArray[randomTopicPlace];
    }

    private String getProfessionByTopic(Chapter topic) {
        if (topic.name().equalsIgnoreCase("crypto")) {
            return "crypto analyst ";
        }
        if (topic.name().equalsIgnoreCase("trading")) {
            return "crypto trader ";
        }
        if (topic.name().equalsIgnoreCase("tech")) {
            return "technical engineer ";
        }
        if (topic.name().equalsIgnoreCase("it")) {
            return "software developer ";
        }
        if (topic.name().equalsIgnoreCase("diy")) {
            return "handyman ";
        }
        return "on your choice ";
    }

    public PromptComposer(TopicService topicService) {
        this.topicService = topicService;
    }
}

